
#include "fp.h"
#include "matfp.hpp"
#include "matfpMath.hpp"
#include "matfpConv.hpp"
#include "matq.h"
#include "matqConv.h"
#include "matqMath.h"
#include "bf.h"
#include "matc.hpp"
#include "matcConv.hpp"
#include "matcMath.hpp"
#include "poly.h"
#include "polyConv.h"
#include "polyMath.h"
#include "polyFactor.h"
#include "mbMod.h"

using namespace std;

// generates seed matrix for given primitive polynomial belonging to (p, m)
int main (int argc, char * const argv[])
{
    matq        z;
    poly        x;
    poly        cp;
    int         m, len;
    double      p;
    string      inString;
    char        *xString;
    
    
    srand (time(NULL));
again:
    p = 0;
    while(p<2 || !isItPrime(p, 35))
    {
        cout << "p: ";
        cin >> p;
    }
    cin.ignore();  // needed for next cin with prompt to behave
    
    cout << "poly: ";
    getline(cin, inString);
    cout << endl;
    
    len = strlen(inString.c_str());
    xString = (char*)malloc((len+1)*sizeof(char));
    strcpy(xString, inString.c_str());
    
    if(!polyConvFromxString(x, xString))
    {
        cout << "bad input" << endl << endl;
        goto again;
    }
    free(xString);
    
    m = x.deg;
    
    do
    {
        z = genRandIntMatOverp(m, m, p);
        charPoly(cp, z);
        cp = cp % p;
    }while (cp!=x);
    
    cout << "seed matrix = " << z << endl << endl;
    
    goto again;
    
    return 0;
}

